/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.Emulator;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.core.RAMEvent;
import jace.core.Utility;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

@Name(value="Super Serial Card")
public class CardSSC
extends Card
implements Reconfigurable,
Runnable {
    @ConfigurableField(name="TCP/IP Port", shortName="port")
    public static short IP_PORT = (short)1977;
    protected ServerSocket socket;
    protected Socket clientSocket;
    protected Thread listenThread;
    private int lastInputByte = 0;
    private boolean FULL_ECHO = true;
    private boolean RECV_ACTIVE = true;
    private boolean TRANS_ACTIVE = true;
    @ConfigurableField(name="Strip LF (recv)", shortName="stripLF", defaultValue="false", description="Strip incoming linefeeds")
    public boolean RECV_STRIP_LF = false;
    @ConfigurableField(name="Add LF (send)", shortName="addLF", defaultValue="false", description="Append linefeeds after outgoing carriage returns")
    public boolean TRANS_ADD_LF = false;
    private boolean DTR = true;
    public int SW1 = 1;
    public int SW1_SETTING = 240;
    public int SW2_CTS = 2;
    private static int SW2_SETTING = 4;
    public int ACIA_Data = 8;
    public int ACIA_Status = 9;
    public int ACIA_Command = 10;
    public int ACIA_Control = 11;
    public boolean PORT_CONNECTED = false;
    public boolean RECV_IRQ_ENABLED = false;
    public boolean TRANS_IRQ_ENABLED = false;
    public boolean IRQ_TRIGGERED = false;
    private int DATA_BITS = 127;
    ImageIcon activityIndicator;
    long lastSuccessfulWrite = -1L;
    @ConfigurableField(category="Advanced", name="Liveness check interval", description="How often the connection is polled for signs of life (in milliseconds)")
    public int livenessCheck = 10000;

    @Override
    public String getDeviceName() {
        return "Super Serial Card";
    }

    @Override
    public void setSlot(int slot) {
        try {
            this.loadRom("jace/data/SSC.rom");
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.setSlot(slot);
        this.activityIndicator = Utility.loadIcon("network-wired.png");
        this.activityIndicator.setDescription("Slot " + slot);
    }

    @Override
    public void run() {
        while (this.socket != null && !this.socket.isClosed()) {
            try {
                Logger.getLogger(CardSSC.class.getName()).log(Level.INFO, "Slot " + this.getSlot() + " listening on port " + IP_PORT, (Throwable)null);
                while ((this.clientSocket = this.socket.accept()) != null) {
                    this.clientConnected();
                    this.clientSocket.setTcpNoDelay(true);
                    while (this.isConnected()) {
                        try {
                            Thread.sleep(this.livenessCheck / 2);
                        }
                        catch (InterruptedException ex) {}
                    }
                    this.clientDisconnected();
                    this.hangUp();
                }
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.FINE, null, ex);
            }
        }
        this.socket = null;
    }

    public void clientConnected() {
        System.err.println("Client connected");
    }

    public void clientDisconnected() {
        System.out.println("Client disconnected");
    }

    public void loadRom(String path) throws IOException {
        InputStream romFile = CardSSC.class.getClassLoader().getResourceAsStream(path);
        int cxRomLength = 256;
        int c8RomLength = 1792;
        byte[] romxData = new byte[256];
        byte[] rom8Data = new byte[1792];
        if (romFile.read(rom8Data) != 1792) {
            throw new IOException("Bad SSC rom size");
        }
        this.getC8Rom().loadData(rom8Data);
        if (romFile.read(romxData) != 256) {
            throw new IOException("Bad SSC rom size");
        }
        this.getCxRom().loadData(romxData);
    }

    @Override
    public void reset() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardSSC.this.suspend();
                CardSSC.this.resume();
            }
        });
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        try {
            int newValue = -1;
            block1 : switch (type) {
                case EXECUTE: 
                case READ_OPERAND: 
                case READ_DATA: 
                case READ: {
                    if (register == this.SW1) {
                        newValue = this.SW1_SETTING;
                    }
                    if (register == this.SW2_CTS) {
                        newValue = SW2_SETTING & 0xFE;
                        newValue |= this.PORT_CONNECTED && this.inputAvailable() ? 0 : 1;
                    }
                    if (register == this.ACIA_Data) {
                        Emulator.getFrame().addIndicator(this, this.activityIndicator);
                        newValue = this.getInputByte();
                        if (this.RECV_IRQ_ENABLED) {
                            this.triggerIRQ();
                        }
                    }
                    if (register == this.ACIA_Status) {
                        newValue = 0;
                        if (this.inputAvailable()) {
                            newValue |= 8;
                        }
                        newValue |= 0x10;
                        if (this.IRQ_TRIGGERED) {
                            newValue |= 0x80;
                        }
                        this.IRQ_TRIGGERED = false;
                    }
                    if (register == this.ACIA_Command) {
                        newValue = 0;
                        if (this.RECV_IRQ_ENABLED) {
                            newValue |= 2;
                        }
                        newValue |= 0xC;
                        if (this.FULL_ECHO) {
                            newValue |= 0x10;
                        }
                    }
                    if (register != this.ACIA_Control) break;
                    newValue = 0;
                    break;
                }
                case WRITE: {
                    if (register == this.ACIA_Data) {
                        Emulator.getFrame().addIndicator(this, this.activityIndicator);
                        this.sendOutputByte(value & 0xFF);
                        if (this.TRANS_IRQ_ENABLED) {
                            this.triggerIRQ();
                        }
                    }
                    if (register == this.ACIA_Command) {
                        boolean bl = this.DTR = (value & 1) == 0;
                        this.RECV_IRQ_ENABLED = (value & 2) == 0 ? !this.DTR : false;
                        switch (value >> 2 & 3) {
                            case 0: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = false;
                                break;
                            }
                            case 1: {
                                this.TRANS_IRQ_ENABLED = true;
                                this.TRANS_ACTIVE = true;
                                break;
                            }
                            case 2: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = true;
                                break;
                            }
                            case 3: {
                                this.TRANS_IRQ_ENABLED = false;
                                this.TRANS_ACTIVE = true;
                            }
                        }
                        this.FULL_ECHO = (value & 0x10) > 0;
                        System.out.println("Echo set to " + this.FULL_ECHO);
                    }
                    if (register != this.ACIA_Control) break;
                    int bits = (value & 0x7F) >> 5;
                    System.out.println("Data bits set to " + (8 - bits));
                    switch (bits) {
                        case 0: {
                            this.DATA_BITS = 255;
                            break block1;
                        }
                        case 1: {
                            this.DATA_BITS = 127;
                            break block1;
                        }
                        case 2: {
                            this.DATA_BITS = 63;
                            break block1;
                        }
                        case 3: {
                            this.DATA_BITS = 31;
                        }
                    }
                }
            }
            if (newValue > -1) {
                e.setNewValue(newValue);
                value = newValue;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void tick() {
    }

    public boolean inputAvailable() throws IOException {
        if (this.isConnected() && this.clientSocket != null && this.clientSocket.getInputStream() != null) {
            return this.clientSocket.getInputStream().available() > 0;
        }
        return false;
    }

    private int getInputByte() throws IOException {
        if (this.inputAvailable()) {
            int in = this.clientSocket.getInputStream().read() & this.DATA_BITS;
            if (this.RECV_STRIP_LF && in == 10 && this.lastInputByte == 13) {
                in = this.clientSocket.getInputStream().read() & this.DATA_BITS;
            }
            this.lastInputByte = in;
        }
        return this.lastInputByte;
    }

    private void sendOutputByte(int i) throws IOException {
        if (this.clientSocket != null && this.clientSocket.isConnected()) {
            try {
                this.clientSocket.getOutputStream().write(i & this.DATA_BITS);
                if (this.TRANS_ADD_LF && (i & this.DATA_BITS) == 13) {
                    this.clientSocket.getOutputStream().write(10);
                }
                this.clientSocket.getOutputStream().flush();
                this.lastSuccessfulWrite = System.currentTimeMillis();
            }
            catch (IOException e) {
                this.lastSuccessfulWrite = -1L;
                this.hangUp();
            }
        } else {
            this.lastSuccessfulWrite = -1L;
        }
    }

    private void setCTS(boolean b) throws InterruptedException {
        this.PORT_CONNECTED = b;
        if (!b) {
            this.reset();
        }
    }

    private boolean getCTS() throws InterruptedException {
        return this.PORT_CONNECTED;
    }

    private void triggerIRQ() {
        this.IRQ_TRIGGERED = true;
        Computer.getComputer().getCpu().generateInterrupt();
    }

    public void hangUp() {
        this.lastInputByte = 0;
        this.lastSuccessfulWrite = -1L;
        if (this.clientSocket != null && this.clientSocket.isConnected()) {
            try {
                this.clientSocket.shutdownInput();
                this.clientSocket.shutdownOutput();
                this.clientSocket.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.clientSocket = null;
    }

    @Override
    public boolean suspend() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.hangUp();
        if (this.listenThread != null && this.listenThread.isAlive()) {
            try {
                this.listenThread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.listenThread = null;
        this.socket = null;
        return super.suspend();
    }

    @Override
    public void resume() {
        if (!this.isRunning()) {
            super.resume();
            this.RECV_IRQ_ENABLED = false;
            this.TRANS_IRQ_ENABLED = false;
            this.IRQ_TRIGGERED = false;
            try {
                this.socket = new ServerSocket(IP_PORT);
                this.socket.setReuseAddress(true);
                this.socket.setSoTimeout(0);
                this.listenThread = new Thread(this);
                this.listenThread.setDaemon(false);
                this.listenThread.setName("SSC port listener");
                this.listenThread.start();
            }
            catch (IOException ex) {
                this.suspend();
                Logger.getLogger(CardSSC.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        if (this.clientSocket == null || !this.clientSocket.isConnected()) {
            return false;
        }
        if (this.lastSuccessfulWrite == -1L || System.currentTimeMillis() > this.lastSuccessfulWrite + (long)this.livenessCheck) {
            try {
                this.sendOutputByte(0);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void handleFirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }
}

